#version 130
#extension GL_EXT_gpu_shader4 : enable
//Floating HeartMod01.fsh  by  icaroleles1  

//https://www.shadertoy.com/view/ttdBz7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 rot(float r) {
    float s = sin(r);
    float c = cos(r);
    return mat2(c, -s, s, c);
}


vec2 h22(vec2 p)
{
    vec3 a = fract(p.xyx * vec3(123.34, 234.34, 345.65));
    a += dot(a, a + 34.45);
    return fract(vec2(a.x * a.y, a.y * a.z));
}

vec2 hashQuad(float t){

    return vec2(fract (sin(8324.*t)*144455.), fract(sin(1138754.*t)*432.));

}

float voronoi(vec2 uv, float t) {
    float minDist = 100.0;
    float cellIndex = 0.0;
    

    vec2 gv = fract(uv)-0.5;
    vec2 id = floor(uv);
    vec2 cid = vec2(0.0);

    for(float y = -1.0; y <= 1.0; y++)
    {
        for(float x = -1.0; x <= 1.0; x++)
        {
            vec2 offs = vec2(x, y);

            vec2 n = h22(id+offs);
            vec2 p = offs+sin(n*t)*0.5;
            float d = length(gv-p);

            if(d<minDist)
            {
                minDist = d;
                cid = id+offs;
            }
        }
    }
    
    return minDist;
}

vec2 mapScene(vec3 p ){

      float v = voronoi(p.xz*0.1, (iTime*1.5));
    v *= voronoi(p.xz*0.15*rot(3.141*0.125), (iTime*1.952)+251.0);
    v *= 0.75;
    v += 0.5;
    
    float pd = smoothstep(p.y, 0.0, v);
    
    return vec2(pd*p.y,1.0);
}

vec2 rayMarch(vec3 ro,vec3 rd){
    float dO = 0.;
    vec2 d;
    for(int i=0;i<100;i++){
     vec3 p = ro + rd*dO;
        d = mapScene(p);
        

        dO+=d.x;
        if(d.x >100.0|| abs(d.x)<.01)
            break;

    }
        float id=d.y;
        float dist = dO;
    
    return vec2(dist,id);
}



vec3 shadeWater(vec3 p){

      vec3 color = vec3(.4,.5,.7) *.6*p.y*1.3;
  for(float i = 0. ; i < 100.; i++){
       vec2 dir = hashQuad(i)-.5;
       
      float d = length(p.xz - vec2(dir.x*50.7,dir.y*80.4));
      float brightness = .0192;
      color +=(brightness /d) * vec3(.9,.7,.1);
       }
       


	return  color;
}

vec3 shadeScene(vec3 p,vec3 ro,vec3 uv,float geometry){
    

return shadeWater(p);
   
}

vec3 heart(vec3 uv, float time){

    vec3 col = vec3(0);
     uv.z+= sqrt(abs(uv.x))*.5;
     
     float d = length(uv.xz);
     float brightness = 2.12;
     col+=(brightness/d*.5) * vec3(.9,.3,.5);
       
     
    
return col;
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(sin(cr), cos(cr),0.0);
	vec3 cu = normalize( cross(cw,cp) );
	vec3 cv = normalize( cross(cu,cw) );
    return mat3( cu, cv, cw );
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
 
 
    vec3 color = vec3(-.2);
    
    vec3 ro = vec3(cos(iTime*.09)*10.    ,6.9,14. );
    vec3 ta = vec3(0,5,2);
    mat3 ca = setCamera( ro, ta, 0.0 );

    vec3 rd = ca *normalize(vec3(uv,1.0));

    vec2 scene = rayMarch(ro,rd);
    vec3 point = ro + rd*scene.x;
  
    if(scene.x<=100. && scene.x>.01){
    
            color = shadeScene(point,ro,rd,scene.y);  
            color+= mix(color *.1,vec3(smoothstep(.01,.09,.006/length(uv-vec2(.0,.2)))),abs(point.z)*(uv.y*.88));
            
            color+=heart(point ,.0);
            
         }

    else{
       color +=vec3(.4,.3,.5);
       color+= smoothstep(.001,.03,.003/(length(uv-vec2(.0,.2))))*vec3(.8768,.865,.98322775);


       for(float i = 0. ; i < 30.; i++){
       vec2 dir = hashQuad(i)-.5;
       
      float d = length(uv.xy - vec2(dir.x*1.7,.3+dir.y*.4));
      
      float brightness = .00112;
      color +=(brightness /d) * vec3(.9,.7,.1);
      color +=1.2/length(point.xz) * vec3(.9,.7,.9);

       }
    }
        // Output to screen
    float GAMMA = 2.2;
    color = pow(color,vec3(GAMMA));
    
  //  color = color / (vec3(vec3(1)+color));
    fragColor = vec4((color.xyz),1.0);
    return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.